/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Collection;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.DatabaseTask;
import oracle.ops.verification.framework.engine.task.DatabaseTaskException;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOSDbGroupsExistence
extends DatabaseTask {
    private static final String[] m_osgroups = new String[]{"OSDBA", "ASMDBA", "SYSOPER", "SYSBACKUP", "SYSDG", "SYSKM"};
    private static final String[] m_oskeys = new String[]{"-d", "-a", "-o", "-b", "-g", "-k"};
    private String[] m_groupnames;

    public TaskOSDbGroupsExistence(Version crsVer, Collection<DatabaseConnectInfo> dbConInfo) {
        super(crsVer, dbConInfo);
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        ArrayList<String> failedDBList = new ArrayList<String>();
        String failedDB = "";
        String commaString = "";
        Trace.out((String)"Performing OSDB groups consistency check...");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11313", false));
        for (String database : this.databases()) {
            ErrorDescription errDesc;
            String errMsg;
            try {
                String[] nodeList = this.m_dbUtils.getNodes(database);
                DatabaseInfo dbInfo = this.getDatabaseInfo(database);
                String oraHome = dbInfo.getHome();
                if (!this.verifyGroupConsistency(nodeList, oraHome, database)) {
                    retVal &= false;
                    Trace.out((String)("Check for consistency failed for database " + database + "."));
                    String errMsg2 = s_gMsgBundle.getMessage("11317", false, (Object[])new String[]{database});
                    ReportUtil.sureprintln(errMsg2);
                    ErrorDescription errDesc2 = new ErrorDescription(errMsg2);
                    this.m_resultSet.addErrorDescription(database, errDesc2);
                    this.m_resultSet.addResult(database, 3);
                } else {
                    Trace.out((String)("Check for OSDB consistency passed for database " + database + "."));
                    ReportUtil.sureprintln(s_gMsgBundle.getMessage("11316", false, (Object[])new String[]{database}));
                    this.m_resultSet.addResult(database, 1);
                }
            }
            catch (DBUtilsException duEx) {
                Trace.out((String)("DBUtilsException while verifying OSDB groups for database " + database + ". message :" + duEx.getMessage()));
                errMsg = s_gMsgBundle.getMessage("11318", true, (Object[])new String[]{duEx.getMessage()});
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addResult(database, 2);
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(database, errDesc);
                VerificationLogData.log(errMsg);
                retVal &= false;
            }
            catch (DatabaseTaskException dbEx) {
                Trace.out((String)("DatabaseTaskException while verifying OSDB groups for database " + database + ". message :" + dbEx.getMessage()));
                errMsg = s_gMsgBundle.getMessage("11318", true, (Object[])new String[]{dbEx.getMessage()});
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addResult(database, 2);
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(database, errDesc);
                VerificationLogData.log(errMsg);
                retVal &= false;
            }
            if (retVal) continue;
            failedDBList.add(database);
            failedDB = failedDB + commaString + database;
            commaString = ", ";
        }
        if (retVal) {
            Trace.out((String)"Check for OSDB groups consistency passed");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11315", false));
            this.m_resultSet.addResult(this.databases(), 1);
        } else {
            Trace.out((String)"Check for OSDB groups consistency failed");
            failedDBList.trimToSize();
            String errMsg = s_gMsgBundle.getMessage("11314", true, (Object[])new String[]{failedDB});
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResult(failedDBList.toArray(new String[0]), 3);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            VerificationLogData.log(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        return retVal;
    }

    private boolean verifyGroupConsistency(String[] nodeList, String oraHome, String database) {
        Trace.out((String)"Start consistency  check...");
        boolean retVal = true;
        boolean groupCheckPassed = true;
        String groupResult = "";
        ArrayList<String> failedNodeList = new ArrayList<String>();
        TaskGroupExistence tGrpExistence = null;
        for (int i = 0; i < m_osgroups.length; ++i) {
            int j;
            Trace.out((String)("Starting consistency check for group " + m_osgroups[i]));
            this.m_groupnames = this.getOSDBGrp(nodeList, oraHome, m_oskeys[i], database);
            for (j = 0; j < this.m_groupnames.length; ++j) {
                if (j == 0) {
                    groupResult = this.m_groupnames[j];
                }
                if (this.m_groupnames[j].equals(groupResult) && !"".equals(groupResult)) continue;
                Trace.out((String)("Group " + m_osgroups[i] + " not consistent in node " + nodeList[j]));
                retVal &= false;
                groupCheckPassed &= false;
                if (failedNodeList.contains(nodeList[j])) continue;
                failedNodeList.add(nodeList[j]);
            }
            if (groupCheckPassed) {
                for (j = 0; j < this.m_groupnames.length; ++j) {
                    tGrpExistence = new TaskGroupExistence(this.m_groupnames[j]);
                    tGrpExistence.setNodeList(nodeList);
                    if (!tGrpExistence.performTask()) {
                        this.m_resultSet.uploadResultSet(tGrpExistence.getResultSet());
                        for (String failNode : this.m_resultSet.getFailureNodes()) {
                            if (failedNodeList.contains(failNode)) continue;
                            failedNodeList.add(failNode);
                        }
                        retVal &= false;
                        groupCheckPassed &= false;
                        continue;
                    }
                    Trace.out((String)("Check for existance of group " + m_osgroups[i] + " for database " + database + " passed"));
                }
            }
            if (groupCheckPassed) {
                Trace.out((String)("Group " + m_osgroups[i] + " passed consistency check for database " + database + "."));
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("11319", false, (Object[])new String[]{m_osgroups[i], database}));
            } else {
                failedNodeList.trimToSize();
                String failNodes = "";
                String commaString = "";
                for (String node : failedNodeList.toArray(new String[0])) {
                    failNodes = failNodes + node + commaString;
                    commaString = ", ";
                }
                String errMsg = s_gMsgBundle.getMessage("11320", false, (Object[])new String[]{m_osgroups[i], failNodes, database});
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addResult(database, 3);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(database, errDesc);
                failedNodeList.clear();
            }
            groupCheckPassed = true;
        }
        return retVal;
    }

    private String[] getOSDBGrp(String[] nodeList, String oraHome, String keyArg, String database) {
        int i;
        String[] dbaGrp = new String[nodeList.length];
        VerificationCommand[] command = new VerificationCommand[nodeList.length];
        String[] args = new String[]{"-rungencmd", "" + oraHome + FSEP + "bin" + FSEP + "osdbagrp", keyArg};
        ResultSet rs = new ResultSet();
        for (i = 0; i < nodeList.length; ++i) {
            command[i] = new VerificationCommand(nodeList[i], args, null);
        }
        Trace.out((String)("Command sent: osdbagrp " + keyArg));
        new GlobalHandler().submit((Command[])command, 0, rs);
        if (rs.allSuccess()) {
            for (i = 0; i < command.length; ++i) {
                dbaGrp[i] = command[i].getOutput();
                Trace.out((String)("Response from osdbagrp for node  " + nodeList[i] + ": " + dbaGrp[i]));
            }
            return dbaGrp;
        }
        String cause = "";
        for (VerificationError vfe : rs.getErrors()) {
            String errMsg = vfe.getErrorMessage().replace("|", LSEP);
            cause = cause + LSEP + VerificationUtil.fetchVerificationValue(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(database, 2);
            this.m_resultSet.addErrorDescription(database, errDesc);
            Trace.out((String)("Error message from osdbagrp:" + cause));
        }
        return dbaGrp;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11312", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11311", false);
    }
}

